/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.expr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWString;
import filenet.vw.base.expr.Lexer;
import filenet.vw.base.expr.VWOpCode;
import java.util.Hashtable;

public class VWExprEmit {
    Lexer myLexer;
    VWWorkflowDefinition theWFL = null;
    boolean bBadIdentToken = false;
    int theResultDataType;
    boolean theResultIsArray = false;
    int expectedFieldType = -1;
    boolean bGotError = false;
    boolean bAlreadyGotBadOperand = false;
    boolean tempResultType;
    int theSubScriptDepth;
    Hashtable theYaccErrors = null;

    public VWExprEmit() {
    }

    public VWExprEmit(VWWorkflowDefinition newWorkflow, Lexer theLexer, Hashtable yaccErrors) {
        this.theWFL = newWorkflow;
        this.myLexer = theLexer;
        this.theYaccErrors = yaccErrors;
    }

    public void setLexer(Lexer theLexer) {
        this.myLexer = theLexer;
    }

    public void setYaccErrors(Hashtable yaccErrors) {
        this.theYaccErrors = yaccErrors;
    }

    public boolean gotError() {
        return this.bGotError;
    }

    public boolean wasIdentTokenBad() {
        return this.bBadIdentToken;
    }

    public void setResultDataType(int resultType, boolean tempDataType) {
        this.theResultDataType = resultType;
        this.tempResultType = tempDataType;
        this.theResultIsArray = this.isArray(resultType);
        switch (resultType) {
            case -3: {
                this.theResultDataType = 1;
                break;
            }
            case -9: {
                this.theResultDataType = 4;
                break;
            }
            case -5: {
                this.theResultDataType = 2;
                break;
            }
            case -8: {
                this.theResultDataType = 16;
                break;
            }
            case -6: {
                this.theResultDataType = 32;
                break;
            }
            case -7: {
                this.theResultDataType = 64;
                break;
            }
            case -4: {
                this.theResultDataType = 8;
                break;
            }
        }
    }

    public int getResultDataType() {
        return this.theResultDataType;
    }

    public boolean getResultIsArray() {
        return this.theResultIsArray;
    }

    int findBestType(int type1, int type2) {
        int newType = type1;
        if (type2 == -2) {
            newType = type2;
        }
        if (type1 != type2 && type1 != -2 && type2 != -2) {
            block0 : switch (type1) {
                case -3: 
                case 1: {
                    switch (type2) {
                        case -4: 
                        case -3: 
                        case 1: 
                        case 8: {
                            newType = type2;
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -4: 
                case 8: {
                    switch (type2) {
                        case -4: 
                        case -3: 
                        case 1: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -5: 
                case 2: {
                    switch (type2) {
                        case -5: 
                        case 2: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -9: 
                case 4: {
                    switch (type2) {
                        case -9: 
                        case 4: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -8: 
                case 16: {
                    switch (type2) {
                        case -8: 
                        case 16: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -7: 
                case 64: {
                    switch (type2) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 64: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                case -6: 
                case 32: {
                    switch (type2) {
                        case -6: 
                        case -5: 
                        case 2: 
                        case 32: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
        return newType;
    }

    int emitBestType2(VWOpCode opCode, int type1, int type2) {
        int bestType = this.findBestType(type1, type2);
        return bestType;
    }

    int findBestNumericType(int type1, int type2) {
        this.checkNumericType(type1);
        return this.findBestType(type1, type2);
    }

    int emitBestNumericType2(VWOpCode opCode, int type1, int type2) {
        this.checkNumericType(type1);
        return this.emitBestType2(opCode, type1, type2);
    }

    int emitNumericType(VWOpCode opCode, int type1) {
        this.checkNumericType(type1);
        this.emit(opCode);
        return type1;
    }

    int emitAdd(int type1, int type2) {
        int resultType;
        if (!(type1 != 2 && type1 != -2 || type2 != 2 && type2 != -2)) {
            this.emit(new VWOpCode(24));
            resultType = type1 == -2 || type2 == -2 ? -2 : 2;
        } else {
            this.checkNumericType(type1);
            this.checkNumericType(type2);
            resultType = this.emitBestType2(new VWOpCode(24), type1, type2);
        }
        return resultType;
    }

    int emitSubtract(int type1, int type2) {
        int resultType;
        if (!(type1 != 16 && type1 != -2 || type2 != 16 && type2 != -2 || type1 != type2 && type1 != -2 && type2 != -2)) {
            this.emit(new VWOpCode(25));
            resultType = type1 == -2 || type2 == -2 ? type1 : 1;
        } else {
            this.checkNumericType(type1);
            this.checkNumericType(type2);
            resultType = this.emitBestType2(new VWOpCode(25), type1, type2);
        }
        return resultType;
    }

    void checkNumericType(int typeFound) {
        this.checkCompatibleType(1, typeFound);
    }

    void checkCompatibleType(int typeExpected, int typeFound) {
        if (typeFound != typeExpected && typeFound != -2) {
            block0 : switch (typeExpected) {
                case 1: 
                case 8: {
                    switch (typeFound) {
                        case 1: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
    }

    void addError(VWString theMessage) {
        this.bGotError = true;
        this.theYaccErrors.put(new Integer(this.theYaccErrors.size()), theMessage);
    }

    void throwBadOperandTypes() {
        if (!this.bAlreadyGotBadOperand) {
            VWString theMessage = new VWString("vw.api.VWExprEmitBadOperand", "Got a bad type for operand(s) in the expression.   Offset: {0}", new Integer(this.myLexer.fn_getLineOffset()));
            this.addError(theMessage);
            this.bAlreadyGotBadOperand = true;
        }
    }

    int emit(VWOpCode opCode) {
        return opCode.getOpCodeValue();
    }

    int emitType(VWOpCode opCode, int typeExpected, int typeFound) {
        if (typeFound != typeExpected) {
            switch (typeExpected) {
                case 2: {
                    if (typeFound == 64 || typeFound == 32) break;
                    this.throwBadOperandTypes();
                    break;
                }
                default: {
                    this.throwBadOperandTypes();
                }
            }
        }
        return opCode.getOpCodeValue();
    }

    int emitType2(VWOpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 || typeFound2 != typeExpected2 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        return opCode.getOpCodeValue();
    }

    public void checkType(int typeExpected, int typeFound) {
        if (typeFound != typeExpected) {
            this.throwBadOperandTypes();
        }
    }

    boolean bothStrings(int X, int Y) {
        return !(X != 2 && X != 32 && X != 64 || Y != 2 && Y != 32 && Y != 64);
    }

    int emitType3(VWOpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 || typeFound2 != typeExpected2 && typeFound2 != -2 || typeFound3 != typeExpected3 && typeFound3 != -2) {
            this.throwBadOperandTypes();
        }
        return opCode.getOpCodeValue();
    }

    public int emitStringLit(String str) {
        return 2;
    }

    int emitNumericConvertType(VWOpCode opCode, int typeExpected, int typeFound) {
        this.checkNumericType(typeFound);
        return opCode.getOpCodeValue();
    }

    int emitNumericConvertType2(VWOpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        this.checkNumericType(typeFound1);
        this.checkNumericType(typeFound2);
        return opCode.getOpCodeValue();
    }

    int emitNumericConvertType3(VWOpCode opCode, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2, int typeExpected3, int typeFound3) {
        this.checkNumericType(typeFound1);
        this.checkNumericType(typeFound2);
        this.checkNumericType(typeFound3);
        return opCode.getOpCodeValue();
    }

    int emitBestResult2(VWOpCode opCode, int type1, int type2) {
        this.emitBestType2(opCode, type1, type2);
        return opCode.getOpCodeValue();
    }

    int emitTrim(int opCodeVal1, int opCodeVal2, int typeFound1, int typeFound2) {
        if (typeFound1 != 2 && typeFound1 != -2 || typeFound2 != 2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        VWOpCode opCode = new VWOpCode(typeFound2 == -1 ? opCodeVal1 : opCodeVal2);
        return opCode.getOpCodeValue();
    }

    int emitOptType2(VWOpCode opCode1, VWOpCode opCode2, int typeExpected1, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != typeExpected1 && typeFound1 != -2 || typeFound2 != typeExpected2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        int resultType = opCode1.getOpCodeValue();
        return resultType;
    }

    int emitOptTimeType2(VWOpCode opCode1, VWOpCode opCode2, int typeFound1, int typeExpected2, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 && typeFound1 != 2 || typeFound2 != typeExpected2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        int resultType = opCode1.getOpCodeValue();
        return resultType;
    }

    int emitTime2(VWOpCode opCode, int typeFound1, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 || typeFound2 != 16 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        if (typeFound1 != -2 && typeFound2 != -2 && typeFound1 != typeFound2) {
            this.throwBadOperandTypes();
        }
        return opCode.getOpCodeValue();
    }

    int emitTimeNum2(VWOpCode opCode, int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 16 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        return opCode.getOpCodeValue();
    }

    int emitDateTimeNum2(VWOpCode opCode, int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 16 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        return typeFound1;
    }

    int emitWeekDay(int typeFound) {
        if (typeFound != 16 && typeFound != -2) {
            this.throwBadOperandTypes();
        }
        return 1;
    }

    int emitStrIns(int typeFound1, int typeFound2, int typeFound3) {
        this.checkNumericType(typeFound3);
        if (typeFound1 != 2 && typeFound1 != -2 || typeFound2 != 2 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        return 2;
    }

    int emitSubStr(int typeFound1, int typeFound2, int typeFound3) {
        this.checkNumericType(typeFound2);
        if (typeFound3 != -1) {
            this.checkNumericType(typeFound3);
        }
        if (typeFound1 != 2 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        return 2;
    }

    int emitRepeat(int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound2);
        if (typeFound1 != 2 && typeFound1 != -2) {
            this.throwBadOperandTypes();
        }
        return 2;
    }

    int emitNumberToString(int typeFound1, int typeFound2) {
        this.checkNumericType(typeFound1);
        if (typeFound2 != 2 && typeFound2 != -2 && typeFound2 != -1) {
            this.throwBadOperandTypes();
        }
        return 2;
    }

    int emitDaysBetween(int typeFound1, int typeFound2) {
        if (typeFound1 != 16 && typeFound1 != -2 || typeFound2 != 16 && typeFound2 != -2) {
            this.throwBadOperandTypes();
        }
        if (typeFound1 != -2 && typeFound2 != -2 && typeFound1 != typeFound2) {
            this.throwBadOperandTypes();
        }
        return 1;
    }

    int emitIf(int typeFound) {
        if (typeFound != 4 && typeFound != -2) {
            this.throwBadOperandTypes();
        }
        return 0;
    }

    int emitGoto(int ifOffset) {
        return 0;
    }

    int fixupGoto(int gotoOffset, int typeFound1, int typeFound2) {
        return this.findBestType(typeFound1, typeFound2);
    }

    int emitFieldDefined1(int opCode, int type1) {
        if (type1 != 2 && type1 != -2) {
            this.throwBadOperandTypes();
        }
        return 4;
    }

    int emitFieldDefined2(int type1, int type2) {
        if (type1 != -2 || type2 != 2 && type2 != -2) {
            this.throwBadOperandTypes();
        }
        return 4;
    }

    int emitIsValid(int type1, int type2) {
        return 4;
    }

    int emitEnvField(int opCode, int type1, int type2) {
        return type2;
    }

    int emitIdent(String name, boolean isAlt, boolean allowFieldNames) throws VWException {
        int returnType = -1;
        if (!allowFieldNames) {
            this.bBadIdentToken = true;
            VWString theMessage = new VWString("vw.api.VWExprEmitIdentifierNotAllowed", "The expression contains an identifier, \"{0}\", possibly an attempt to reference another field, field references are not allowed in field initialization expressions.", name);
            this.addError(theMessage);
            returnType = -2;
        } else {
            try {
                if (this.theWFL != null) {
                    VWFieldDefinition theField = this.theWFL.getField(name);
                    if (theField != null) {
                        returnType = this.theWFL.getField(name).getFieldType();
                        if (this.theWFL.getField(name).isArray()) {
                            returnType = this.getArrayType(returnType);
                        }
                    } else {
                        this.bBadIdentToken = true;
                        VWString theMessage = new VWString("vw.api.VWExprEmitInvalidIdentifier", "The field \"{0}\" in the expression is an invalid field name.", name);
                        this.addError(theMessage);
                        returnType = -2;
                    }
                }
            }
            catch (VWException e) {
                if (name.equalsIgnoreCase("F_RESPONSECOUNT")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_RESPONSES")) {
                    returnType = this.getArrayType(1);
                }
                if (name.equalsIgnoreCase("F_ORIGINATOR")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_STARTTIME")) {
                    returnType = 16;
                }
                if (name.equalsIgnoreCase("F_SUBJECT")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_TIMEOUT")) {
                    returnType = 16;
                }
                if (name.equalsIgnoreCase("F_TRACKERS")) {
                    returnType = this.getArrayType(64);
                }
                if (name.equalsIgnoreCase("F_WORKSPACEID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_LOCKED")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_LOCKMACHINE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_LOCKUSER")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_LOCKTIME")) {
                    returnType = 16;
                }
                if (name.equalsIgnoreCase("F_BINDPENDING")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_BOUNDUSER")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_BOUNDMACHINE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_TAG")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_OPERATIONID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_WORKCLASSID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_QUEUEWPCLASSID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_ENQUEUETIME")) {
                    returnType = 16;
                }
                if (name.equalsIgnoreCase("F_CREATETIME")) {
                    returnType = 16;
                }
                if (name.equalsIgnoreCase("F_INSTRSHEETID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_WORKORDERID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_SORTORDER")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_SERVERID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_WOBNUM")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_UNIQUEID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_CLASS")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_OPERATION")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_WORKFLOWNUMBER")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_PARENTWOBNUM")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_SPLITLEG")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_TRACKERSTATUS")) {
                    returnType = 4;
                }
                if (name.equalsIgnoreCase("F_OVERDUE")) {
                    returnType = 4;
                }
                if (name.equalsIgnoreCase("F_RESPONSE")) {
                    returnType = 2;
                }
                if (name.equalsIgnoreCase("F_TRANSFERUSER")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_STEPPROCID")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_MINMILESTONE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_MAXMILESTONE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_OCCURRENCE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_WFDEADLINE")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_WFREMINDER")) {
                    returnType = 1;
                }
                if (name.equalsIgnoreCase("F_COMMENT")) {
                    returnType = 2;
                }
                this.bBadIdentToken = true;
                VWString theMessage = new VWString("vw.api.VWExprEmitInvalidIdentifier", "The field \"{0}\" in the expression is an invalid field name.", name);
                this.addError(theMessage);
                returnType = -2;
            }
        }
        return returnType;
    }

    int emitConvert(int currentType, int resultType, boolean isConst, int dimensions) {
        int result;
        block4: {
            result = resultType;
            int basicType = currentType;
            if (dimensions == 0 && this.isArray(currentType) || dimensions > 0 && !this.isArray(currentType)) {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadConvert", "Got a bad convert type in expression.  Line: {0}  Offset: {1}", new Integer(this.myLexer.fn_getLineNumber()), new Integer(this.myLexer.fn_getLineOffset()));
                this.addError(theMessage);
            }
            if (dimensions > 0) {
                basicType = this.getBasicTypeForArray(currentType);
                result = this.getArrayType(resultType);
            }
            try {
                VWOpCode.checkConversion(basicType, resultType, isConst);
            }
            catch (VWException e) {
                String theKey = e.getKey();
                if (theKey.compareTo("vw.api.VWOpCodeBadConvertType") != 0) break block4;
                VWString theMessage = new VWString("vw.api.VWExprEmitBadConvertTypeMessage", "Invalid type: {0}", e.getMessage());
                this.addError(theMessage);
            }
        }
        return result;
    }

    boolean isArray(int elemType) {
        return elemType == -3 || elemType == -9 || elemType == -5 || elemType == -8 || elemType == -6 || elemType == -7 || elemType == -4;
    }

    int getArrayType(int elemType) {
        int arrayType = elemType;
        if (this.isArray(arrayType)) {
            return arrayType;
        }
        switch (elemType) {
            case 1: {
                arrayType = -3;
                break;
            }
            case 4: {
                arrayType = -9;
                break;
            }
            case 2: {
                arrayType = -5;
                break;
            }
            case 16: {
                arrayType = -8;
                break;
            }
            case 32: {
                arrayType = -6;
                break;
            }
            case 64: {
                arrayType = -7;
                break;
            }
            case 8: {
                arrayType = -4;
                break;
            }
            default: {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadType", "Invalid field type.");
                this.addError(theMessage);
            }
        }
        return arrayType;
    }

    int getBasicTypeForArray(int arrayType) {
        int basicType = arrayType;
        if (!this.isArray(basicType)) {
            return basicType;
        }
        switch (arrayType) {
            case -3: {
                basicType = 1;
                break;
            }
            case -9: {
                basicType = 4;
                break;
            }
            case -5: {
                basicType = 2;
                break;
            }
            case -8: {
                basicType = 16;
                break;
            }
            case -6: {
                basicType = 32;
                break;
            }
            case -7: {
                basicType = 64;
                break;
            }
            case -4: {
                basicType = 8;
                break;
            }
            default: {
                VWString theMessage = new VWString("vw.api.VWExprEmitBadType", "Invalid field type.");
                this.addError(theMessage);
            }
        }
        return basicType;
    }

    int emitArrayConst(int elemType) {
        return this.getArrayType(elemType);
    }

    void emitBeginSubScript() {
        ++this.theSubScriptDepth;
    }

    int emitSubscript(int arrayType, int subDataType) {
        if (!this.isArray(arrayType)) {
            VWString theMessage = new VWString("vw.api.VWExprNotArray", "Identifier must be an array.");
            this.addError(theMessage);
        }
        this.emitNumericConvertType(new VWOpCode(14), 1, subDataType);
        return this.getArrayType(arrayType);
    }

    void emitEndSubScript() {
        --this.theSubScriptDepth;
    }
}

